#pragma rtGlobals=1		// Use modern global access method.

//#include "AcqInit"
#include "PreTreatmentInit"
#include "ParticlesInit"
#include "AnalysisInit"
#include "Detector"
//*****************************************************************************************************
//***************************************** Menu  Functions ***************************************
//*****************************************************************************************************
//------------------------------------------------------------------------------------------------------------------------------
// Definition of the Menu
//------------------------------------------------------------------------------------------------------------------------------

Menu "CIEL+", dynamic
	InitCiel()
End

//---------------------------------------------------------------------------------------------------------------------------------
// 								Initialization Function
// Input : None
// Output : If there is no acquisition folder, then create the structure, waves and variables 
// 			for the acquisition
//---------------------------------------------------------------------------------------------------------------------------------

Function/S InitCiel()

InitPreTreatment()

End


//_---------------------------------------------------------------------------------------------------------------
//_---------------------------------------------------------------------------------------------------------------
//_---------------------------------------------------------------------------------------------------------------



Function InitAcq()
If (!DataFolderExists("root:local:"))
	//Folder creation
	NewDataFolder root:local
	NewDataFolder root:local:Acq_Load
	NewDataFolder root:local:Acq_Stat
	NewDataFolder root:local:Acq_Param
	
	// ----------------------------------------------------- Variable Creation --- Local Folder -----------------------------------------------------
	SetDataFolder root:local
	String/G ExpName, WorkPath, Comment
	Variable/G AcquisitionType=1 		// Type of acquisition 1: CIEL electron, 2: CIEL Ion, 3: CIEL electron+ion
	Variable/G Saved=1 				// Type of acquisition 1: CIEL electron, 2: CIEL Ion, 3: CIEL electron+ion	
	Variable/G AcquisitionTime
	// Monochromator
	Variable/G ActualEnergy, ActualLambda
	Variable/G ScanType=0, ScanStart, ScanStop, ScanStep
	// TDC-VME
	Variable/G WindowElec, OffsetElec, WindowIon
	Variable/G VmeRefresh, VmeCpu, LocalCpu
	
	// Ortec
	String/G Channel1, Channel2, Channel3, Channel4
	Variable/G SamplingTime
	
	// Localization-Algo
	Variable/G Dt_ion, Dt_elec
	Variable/G ElecEff, IonEff 
				
	//----------------------------------------------------- Variable Creation --- Load Folder -----------------------------------------------------
	
	SetDataFolder root:
EndIf		
End
